//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Implicitly Unwrapping
//:
//: ## Task:
//:
//: Implicitly unwrapping optionals is a method of declaring an optional variable, which force unwraps the associated value each time it is requested.
//:
//: Execute the code below and witness the runtime error.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


class MyCustomType {
    var stringProperty: String! // Implicitly unwrapping
    
    init(_ stringProperty: String?) {
        self.stringProperty = stringProperty
    }
}

let myCustomInstance: MyCustomType = MyCustomType(nil)
let unwrappedValue: String = myCustomInstance.stringProperty
print(unwrappedValue)


//:
//: -------------------
//:
//: ## Task:
//:
//: Refactor the code above and below to remove implicitly unwrapping optionals.
//:
//: Keep `currentArticle` as an optional type and edit the code to execute the `likeButtonPressed` function safely.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


class Article {
    var liked: Bool = false
}
class NewsFeed {
    var currentArticle: Article!
    func likeButtonPressed() {
        currentArticle.liked = true
    }
    
    init(_ currentArticle: Article?) {
        self.currentArticle = currentArticle
    }
}

let newsFeed = NewsFeed(nil)
newsFeed.likeButtonPressed()


//:
//: -------------------
//:
//: * callout(💡 Tip):
//:     → As a rule, proffesional Swift engineers avoid using this type of unwrapping, but there are times when it's helpful.
//:
//:     Just remember, we should avoid writing any code that could terminate the program.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:
